/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property;

import filenet.vw.toolkit.design.property.event.IVWExpressionTextFieldListener;
import filenet.vw.toolkit.design.property.event.VWExpressionTextFieldEvent;
import filenet.vw.toolkit.design.property.images.VWImageLoader;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionBuilderDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class VWExpressionTextField
extends JPanel
implements ActionListener,
DocumentListener {
    private JTextField m_textField = null;
    private JButton m_launchButton = null;
    private Vector m_actionListeners = null;
    private Frame m_parentFrame = null;
    private Dialog m_parentDialog = null;
    private IVWPropertyData m_propertyData = null;
    private int m_defaultItem = 1;
    private String m_defaultSubItem = null;

    public VWExpressionTextField(Frame parent, IVWPropertyData propertyData) {
        this.m_parentFrame = parent;
        this.m_propertyData = propertyData;
        this.m_actionListeners = new Vector();
        this.initControls();
    }

    public VWExpressionTextField(Dialog parent, IVWPropertyData propertyData) {
        this.m_parentDialog = parent;
        this.m_propertyData = propertyData;
        this.m_actionListeners = new Vector();
        this.initControls();
    }

    public VWExpressionTextField(Frame parent, IVWPropertyData propertyData, int defaultItem, String defaultSubItem) {
        this.m_parentFrame = parent;
        this.m_propertyData = propertyData;
        this.m_defaultItem = defaultItem;
        this.m_defaultSubItem = defaultSubItem;
        this.m_actionListeners = new Vector();
        this.initControls();
    }

    public VWExpressionTextField(Dialog parent, IVWPropertyData propertyData, int defaultItem, String defaultSubItem) {
        this.m_parentDialog = parent;
        this.m_propertyData = propertyData;
        this.m_defaultItem = defaultItem;
        this.m_defaultSubItem = defaultSubItem;
        this.m_actionListeners = new Vector();
        this.initControls();
    }

    public void setText(String text) {
        this.m_textField.getDocument().removeDocumentListener(this);
        this.m_textField.setText(text);
        this.m_textField.getDocument().addDocumentListener(this);
    }

    public String getText() {
        return this.m_textField.getText();
    }

    public void setColumns(int nColumns) {
        if (this.m_textField != null) {
            this.m_textField.setColumns(nColumns);
        }
    }

    public void setEnabled(boolean isEnable) {
        this.m_textField.setEnabled(isEnable);
        this.m_launchButton.setEnabled(isEnable);
    }

    public void addExpressionTextFieldListener(IVWExpressionTextFieldListener listener) {
        this.m_actionListeners.addElement(listener);
    }

    public void removeExpressionTextFieldListener(IVWExpressionTextFieldListener listener) {
        this.m_actionListeners.removeElement(listener);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_launchButton) {
            this.performLaunchButtonAction();
        }
    }

    public void changedUpdate(DocumentEvent event) {
        Document src = event.getDocument();
        if (src == this.m_textField.getDocument()) {
            this.performTextFieldUpdate();
        }
    }

    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    private void initControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.fill = 1;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        this.m_textField = new JTextField();
        this.m_textField.getDocument().addDocumentListener(this);
        this.add((Component)this.m_textField, gbCons);
        gbCons.fill = 0;
        ++gbCons.gridx;
        gbCons.weightx = 0.0;
        this.m_launchButton = VWImageLoader.createIconButton("dots.gif", VWResource.s_launchExpressionBuilderStr);
        this.m_launchButton.addActionListener(this);
        this.add((Component)this.m_launchButton, gbCons);
    }

    private void performLaunchButtonAction() {
        VWExpressionBuilderDialog expressionBuilderDialog = null;
        String expressionString = this.m_textField.getText();
        expressionBuilderDialog = this.m_parentFrame != null ? new VWExpressionBuilderDialog(this.m_parentFrame, this.m_propertyData, null, expressionString, 3727) : new VWExpressionBuilderDialog(this.m_parentDialog, this.m_propertyData, null, expressionString, 3727);
        expressionBuilderDialog.setDefaultItems(this.m_defaultItem, this.m_defaultSubItem);
        expressionBuilderDialog.init();
        expressionBuilderDialog.setVisible(true);
        if (expressionBuilderDialog.getDialogResult() == 0) {
            this.setText(expressionBuilderDialog.getExpressionString());
            this.notifyExpressionTextFieldUpdatedListeners();
        }
    }

    private void performTextFieldUpdate() {
        this.notifyExpressionTextFieldUpdatedListeners();
    }

    private void notifyExpressionTextFieldUpdatedListeners() {
        int count;
        if (this.m_actionListeners != null && (count = this.m_actionListeners.size()) > 0) {
            for (int i = 0; i < count; ++i) {
                IVWExpressionTextFieldListener l = (IVWExpressionTextFieldListener)this.m_actionListeners.elementAt(i);
                l.textUpdated(new VWExpressionTextFieldEvent(this));
            }
        }
    }
}

